# Fomax Logistics Management App - Installation Guide

## Prerequisites

- Web server with PHP 7.0 or higher
- MySQL 5.6 or higher (or MariaDB equivalent)
- PHP extensions: PDO, MySQLi

## Installation Steps

1. **Extract Files**
   - Extract all files to your web server's document root
   - For example: `/var/www/html/fomax-logistics` or `C:\xampp\htdocs\fomax-logistics`

2. **Database Setup**
   - Create a new MySQL database named `fomax_logistics`
   - Import the `fomax_logistics.sql` file:
     ```bash
     mysql -u username -p fomax_logistics < fomax_logistics.sql
     ```

3. **Configure Database Connection**
   - Open `config/database.php`
   - Update the database connection details:
     ```php
     private $host = "localhost";      // Your database host
     private $db_name = "fomax_logistics"; // Database name
     private $username = "your_username";  // Database username
     private $password = "your_password";  // Database password
     ```

4. **Set Up Default Users**
   - Run the setup script to generate password hashes:
     ```bash
     php setup.php
     ```
   - Copy the generated hashes
   - Update the INSERT statements in `fomax_logistics.sql` with these hashes
   - Re-import the SQL file or manually update the user records
   - Delete `setup.php` for security

5. **Test the Installation**
   - Navigate to your application in a web browser
   - Login with the default credentials:
     - Admin: username `admin`, password `admin123`
     - Staff: username `staff1`, password `staff123`

6. **Post-Installation**
   - Change the default passwords immediately after first login
   - Configure your web server's document root to point to the application folder
   - Set appropriate file permissions for security

## Troubleshooting

### Database Connection Issues
- Verify database credentials in `config/database.php`
- Ensure MySQL service is running
- Check firewall settings

### Login Problems
- Verify user records exist in the `users` table
- Ensure password hashes are properly generated
- Check PHP error logs for authentication issues

### Permission Issues
- Ensure web server has read access to all files
- Ensure PHP can write session files (if using file-based sessions)

## Security Recommendations

1. Use strong, unique passwords for all accounts
2. Regularly update PHP and MySQL to latest secure versions
3. Use HTTPS in production environments
4. Restrict database user permissions to only necessary operations
5. Regularly backup the database
6. Remove or secure development files (like setup.php) after installation

## Support

For additional help, consult your system administrator or refer to the main README.md file.