# Fomax Logistics App - Company Logo Implementation

## Overview
This document describes the implementation of the company logo across all pages of the Fomax Logistics application.

## Implementation Details

### Logo File
- **Location**: `images/logo.png`
- **Usage**: Displayed in the header of all admin and user pages
- **Size**: Automatically scaled to 40px height with 15px right margin

### Pages Updated

#### Admin Pages
1. `admin/dashboard.php` - Admin Dashboard
2. `admin/branches.php` - Branch Management
3. `admin/riders.php` - Rider Management
4. `admin/users.php` - User Management
5. `admin/records.php` - Records Management
6. `admin/expenses.php` - Expenses Management
7. `admin/reports.php` - Reports

#### User Pages
1. `user/dashboard.php` - User Dashboard
2. `user/add_record.php` - Add New Record
3. `user/add_expense.php` - Add New Expense
4. `user/my_records.php` - My Records

### Implementation Code
```html
<img src="../images/logo.png" alt="Fomax Logistics" style="height: 40px; margin-right: 15px;">
```

The logo is placed within the existing logo div, maintaining the text-based "Fomax Logistics" heading while adding visual branding.

### Styling
- **Height**: 40px (consistent with header height)
- **Margin**: 15px right spacing to separate from text
- **Alt Text**: "Fomax Logistics" for accessibility
- **Path**: Relative path `../images/logo.png` for all pages

## Benefits

### Brand Recognition
- Consistent visual identity across all application pages
- Professional appearance with company branding
- Improved user experience through recognizable branding

### Accessibility
- Alt text provides context for screen readers
- Maintains existing text-based heading for SEO
- No impact on application functionality

### Maintenance
- Centralized logo file for easy updates
- Consistent implementation across all pages
- Minimal code changes required

## File Structure
The implementation assumes the following file structure:
```
fomax-logistics-app/
├── admin/
├── user/
├── images/
│   └── logo.png
├── ...
```

If the logo file is located elsewhere, the image path in each header will need to be updated accordingly.

## Future Considerations

### Responsive Design
The current implementation uses a fixed height of 40px which works well with the existing header design. For mobile optimization, consider:

1. Reducing logo size on smaller screens:
   ```css
   @media (max-width: 768px) {
       .logo img {
           height: 30px;
       }
   }
   ```

2. Hiding logo text on mobile:
   ```css
   @media (max-width: 768px) {
       .logo h1 {
           display: none;
       }
   }
   ```

### Multiple Logo Formats
For better quality across different devices, consider providing multiple logo formats:
- `logo.png` - Standard resolution
- `logo@2x.png` - High DPI displays
- `logo.svg` - Vector format for scalability

### Lazy Loading
For improved performance, especially on slower connections:
```html
<img src="../images/logo.png" alt="Fomax Logistics" loading="lazy" style="height: 40px; margin-right: 15px;">
```