<?php
// models/Branch.php
class Branch {
    private $conn;
    private $table_name = "branches";

    public $id;
    public $name;
    public $location;
    public $created_at;
    public $updated_at;

    public function __construct($db) {
        $this->conn = $db;
    }

    // Get all branches
    public function getAll() {
        $query = "SELECT * FROM " . $this->table_name . " ORDER BY name";
        $result = mysqli_query($this->conn, $query);
        return $result;
    }

    // Get branch by ID
    public function getById($id) {
        $id = mysqli_real_escape_string($this->conn, $id);
        $query = "SELECT * FROM " . $this->table_name . " WHERE id = '$id' LIMIT 1";
        $result = mysqli_query($this->conn, $query);
        
        if($result && mysqli_num_rows($result) > 0) {
            $row = mysqli_fetch_assoc($result);
            $this->id = $row['id'];
            $this->name = $row['name'];
            $this->location = $row['location'];
            $this->created_at = $row['created_at'];
            $this->updated_at = $row['updated_at'];
            return true;
        }
        return false;
    }

    // Create branch
    public function create() {
        // Sanitize
        $this->name = mysqli_real_escape_string($this->conn, htmlspecialchars(strip_tags($this->name)));
        $this->location = mysqli_real_escape_string($this->conn, htmlspecialchars(strip_tags($this->location)));
        
        $query = "INSERT INTO " . $this->table_name . " SET name='$this->name', location='$this->location'";
        
        $result = mysqli_query($this->conn, $query);
        
        if($result) {
            return true;
        }
        return false;
    }

    // Update branch
    public function update() {
        // Sanitize
        $this->name = mysqli_real_escape_string($this->conn, htmlspecialchars(strip_tags($this->name)));
        $this->location = mysqli_real_escape_string($this->conn, htmlspecialchars(strip_tags($this->location)));
        $this->id = mysqli_real_escape_string($this->conn, htmlspecialchars(strip_tags($this->id)));
        
        $query = "UPDATE " . $this->table_name . " 
                  SET name = '$this->name', location = '$this->location' 
                  WHERE id = '$this->id'";
        
        $result = mysqli_query($this->conn, $query);
        
        if($result) {
            return true;
        }
        return false;
    }

    // Delete branch
    public function delete() {
        $this->id = mysqli_real_escape_string($this->conn, $this->id);
        $query = "DELETE FROM " . $this->table_name . " WHERE id = '$this->id'";
        $result = mysqli_query($this->conn, $query);
        
        if($result) {
            return true;
        }
        return false;
    }
}
?>