<?php
// syntax_check.php
// Check for PHP syntax errors in key files

$files = [
    'models/Record.php',
    'models/User.php',
    'models/Branch.php',
    'models/Rider.php',
    'models/Expense.php',
    'admin/dashboard.php',
    'user/dashboard.php'
];

echo "Checking PHP syntax for key files...\n\n";

foreach ($files as $file) {
    if (file_exists($file)) {
        echo "Checking $file... ";
        $output = [];
        $return_code = 0;
        exec("php -l " . escapeshellarg($file), $output, $return_code);
        
        if ($return_code === 0) {
            echo "OK\n";
        } else {
            echo "ERROR\n";
            foreach ($output as $line) {
                echo "  $line\n";
            }
        }
    } else {
        echo "File $file not found\n";
    }
}

echo "\nSyntax check completed.\n";
?>