<?php
// test_admin_login.php
// Simple test script to check if admin login works

require_once 'config/database.php';
require_once 'models/User.php';

echo "Testing admin login functionality...\n";

$database = new Database();
$db = $database->getConnection();

if ($db) {
    echo "Database connection successful!\n";
    
    // Test a simple query
    $result = mysqli_query($db, "SELECT VERSION() as version");
    if ($result) {
        $row = mysqli_fetch_assoc($result);
        echo "MySQL version: " . $row['version'] . "\n";
    } else {
        echo "Query failed: " . mysqli_error($db) . "\n";
    }
    
    // Test user model
    $user = new User($db);
    echo "User model loaded successfully!\n";
    
    // Try to get a user
    if ($user->getById(1)) {
        echo "User retrieval successful!\n";
        echo "User ID: " . $user->id . "\n";
        echo "Username: " . $user->username . "\n";
        echo "Role: " . $user->role . "\n";
    } else {
        echo "User retrieval failed!\n";
    }
} else {
    echo "Database connection failed: " . mysqli_connect_error() . "\n";
}

echo "Test completed.\n";
?>