# Fomax Logistics App - Item Valuation Terminology Update

## Overview
This document describes the update from "Price" to "Item Valuation" terminology throughout the Fomax Logistics application to better reflect that this field represents the declared value of items being shipped, not a price charged by the courier company.

## Changes Made

### Database Schema (`fomax_logistics.sql`)
- Renamed `price` column to `item_valuation` in the `records` table
- Updated sample data to use `item_valuation` column name
- Created migration script to rename column in existing installations

### Backend Model (`models/Record.php`)
- Renamed `$price` property to `$item_valuation`
- Updated database queries to reference `item_valuation` column
- Updated summary query to use `SUM(item_valuation) as total_valuation`

### User Interface
1. **Add Record Page** (`user/add_record.php`):
   - Changed label from "Price (₦)" to "Item Valuation (₦)"
   - Updated form field name handling

2. **My Records Page** (`user/my_records.php`):
   - Changed table header from "Price (₦)" to "Item Valuation (₦)"
   - Updated data display to show `item_valuation` field

3. **Admin Records Page** (`admin/records.php`):
   - Changed table header from "Price (₦)" to "Item Valuation (₦)"
   - Updated data display to show `item_valuation` field

## Business Logic Clarification

### For a Courier Company:
- **Item Valuation**: The declared monetary value of items being shipped (provided by the customer)
- **Delivery Charges**: The fees charged by the courier company for shipping services
- **Total Charges Collected**: Only the Delivery Charges (company revenue)

### Financial Model:
- Item Valuation = Client Data (not company revenue)
- Delivery Charges = Company Revenue
- Totals Displayed = Only Delivery Charges

## Benefits

### Clarity
- Eliminates confusion between item value and shipping charges
- Clearly distinguishes client data from company revenue
- Improves understanding for staff and administrators

### Accuracy
- More precise terminology matching courier industry practices
- Better reflects the business model
- Reduces potential for misinterpretation

### Professionalism
- Uses industry-standard terminology
- Enhances application credibility
- Improves user experience

## Implementation Details

### Database Migration
```sql
ALTER TABLE records CHANGE price item_valuation DECIMAL(10, 2) NOT NULL;
```

### Model Updates
- Property renamed from `$price` to `$item_valuation`
- Database field references updated
- Summary calculations updated

### UI Updates
- Form labels changed
- Table headers updated
- Data display adjusted

## Verification

All components were verified to ensure consistency:
- Database schema and sample data
- Backend model properties and queries
- User interface labels and displays
- Financial calculations and summaries

The application now correctly uses "Item Valuation" terminology throughout, providing a more accurate representation of the courier business model.