# Fomax Logistics Management App

A complete internal management application for a logistics company to record and manage daily transactions and expenses.

## Features

### Admin Panel
- Dashboard with overview statistics
- Manage branches (CRUD)
- Manage riders (CRUD) with profile picture support
- Manage users (CRUD)
- View all records with filtering
- View all expenses with filtering
- Generate daily reports

### User (Staff) Panel
- Dashboard with personal statistics
- Add new transaction records
- Add new expenses
- View personal records and expenses

## Technology Stack

- **Frontend**: HTML, CSS, Vanilla JavaScript
- **Backend**: PHP
- **Database**: MySQL/MariaDB (using MySQLi)

## Installation

1. **Database Setup**
   - Create a MySQL database named `fomax_logistics`
   - Import the `fomax_logistics.sql` file to create tables and sample data
   - Run the migration to add the profile picture column to the riders table:
     ```sql
     ALTER TABLE riders ADD COLUMN profile_picture VARCHAR(255) AFTER branch_id;
     ```

2. **Configuration**
   - Update database credentials in `config/database.php` if needed:
     ```php
     private $host = "localhost";
     private $db_name = "fomax_logistics";
     private $username = "root";
     private $password = "";
     ```

3. **File Setup**
   - Create an `uploads` directory in the root of the project with write permissions for storing rider profile pictures

4. **Web Server**
   - Place all files in your web server's document root
   - Ensure PHP and MySQL extensions are enabled

## Default Login Credentials

### Admin
- Username: `admin`
- Password: `admin123`

### Staff User
- Username: `staff1`
- Password: `staff123`

*Note: For security, please change these passwords after first login*

## Folder Structure

```
fomax-logistics-app/
├── admin/              # Admin panel files
├── config/             # Configuration files
├── models/             # Database models
├── user/               # User panel files
├── uploads/            # Rider profile pictures (created during use)
├── fomax_logistics.sql # Database schema
├── login.php           # Login page
└── logout.php          # Logout functionality
```

## Security Notes

- Passwords are securely hashed using PHP's `password_hash()` function
- Session management for authentication
- Input validation and sanitization
- SQL injection prevention using MySQLi with prepared statements
- File upload validation for profile pictures

## Responsive Design

The application is fully responsive and works on:
- Desktop computers
- Tablets
- Mobile devices

## Browser Support

- Chrome (latest)
- Firefox (latest)
- Safari (latest)
- Edge (latest)

## Customization

You can customize the application by:
1. Modifying the CSS styles in each PHP file
2. Adding new fields to the database tables
3. Extending the PHP models
4. Adding new features as needed

## Support

For issues or questions, please contact your system administrator.