# Fomax Logistics App - Terminology Update

## Overview
This document summarizes the changes made to update terminology throughout the Fomax Logistics application to be appropriate for a courier/logistics company rather than a retail shop.

## Terminology Changes

### Database Schema
- `product_name` column in `records` table renamed to `package_description`
- Sample data updated to reflect courier service packages

### Application UI
- "Product Name" field relabeled as "Package Description"
- "Product Sales" metrics renamed to "Package Value"
- All references to "products" changed to "packages"

### Code Changes
1. **Database Schema** (`fomax_logistics.sql`):
   - Column name changed from `product_name` to `package_description`

2. **Models**:
   - `models/Record.php`: Property and database field references updated
   - `models/Expense.php`: Join field references updated

3. **User Interface**:
   - `user/add_record.php`: Form label changed from "Product Name" to "Package Description"
   - `user/my_records.php`: Display column updated
   - `admin/records.php`: Display column updated
   - `admin/reports.php`: Metric label changed from "Total Product Sales" to "Total Package Value"
   - `user/add_expense.php`: Record association display updated

## Migration
A migration script (`migration/rename_product_to_package.php`) has been created to rename the database column in existing installations.

## Benefits
These changes make the application terminology consistent with a courier service business model:
- Packages are shipped rather than products sold
- Delivery services rather than retail transactions
- Courier logistics rather than shop operations

The application now properly reflects its intended use as a logistics management system.