<?php
// migration/add_profile_picture_column.php
require_once '../config/database.php';

echo "Starting migration to add profile_picture column to riders table...\n";

$database = new Database();
$db = $database->getConnection();

if (!$db) {
    die("Connection failed: " . mysqli_connect_error());
}

// Check if the column already exists
$checkQuery = "SHOW COLUMNS FROM riders LIKE 'profile_picture'";
$result = mysqli_query($db, $checkQuery);

if (mysqli_num_rows($result) > 0) {
    echo "Column 'profile_picture' already exists in riders table.\n";
} else {
    // Add the profile_picture column
    $alterQuery = "ALTER TABLE riders ADD COLUMN profile_picture VARCHAR(255) AFTER branch_id";
    
    if (mysqli_query($db, $alterQuery)) {
        echo "Column 'profile_picture' added successfully to riders table.\n";
    } else {
        echo "Error adding column: " . mysqli_error($db) . "\n";
    }
}

echo "Migration completed.\n";
?>