<?php
// migration/rename_price_to_valuation.php
require_once '../config/database.php';

echo "Starting migration to rename price column to item_valuation...\n";

$database = new Database();
$db = $database->getConnection();

if (!$db) {
    die("Connection failed: " . mysqli_connect_error());
}

// Check if the old column exists
$checkQuery = "SHOW COLUMNS FROM records LIKE 'price'";
$result = mysqli_query($db, $checkQuery);

if (mysqli_num_rows($result) > 0) {
    // Rename the column
    $renameQuery = "ALTER TABLE records CHANGE price item_valuation DECIMAL(10, 2) NOT NULL";
    
    if (mysqli_query($db, $renameQuery)) {
        echo "Column 'price' renamed to 'item_valuation' successfully.\n";
    } else {
        echo "Error renaming column: " . mysqli_error($db) . "\n";
    }
} else {
    echo "Column 'price' does not exist. Checking if 'item_valuation' exists...\n";
    
    // Check if the new column already exists
    $checkNewQuery = "SHOW COLUMNS FROM records LIKE 'item_valuation'";
    $newResult = mysqli_query($db, $checkNewQuery);
    
    if (mysqli_num_rows($newResult) > 0) {
        echo "Column 'item_valuation' already exists. No migration needed.\n";
    } else {
        echo "Neither 'price' nor 'item_valuation' column found. Please check your database schema.\n";
    }
}

echo "Migration completed.\n";
?>