<?php
// migration/rename_product_to_package.php
require_once '../config/database.php';

echo "Starting migration to rename product_name column to package_description...
";

$database = new Database();
$db = $database->getConnection();

if (!$db) {
    die("Connection failed: " . mysqli_connect_error());
}

// Check if the old column exists
$checkQuery = "SHOW COLUMNS FROM records LIKE 'product_name'";
$result = mysqli_query($db, $checkQuery);

if (mysqli_num_rows($result) > 0) {
    // Rename the column
    $renameQuery = "ALTER TABLE records CHANGE product_name package_description VARCHAR(100) NOT NULL";
    
    if (mysqli_query($db, $renameQuery)) {
        echo "Column 'product_name' renamed to 'package_description' successfully.
";
    } else {
        echo "Error renaming column: " . mysqli_error($db) . "
";
    }
} else {
    echo "Column 'product_name' does not exist. Checking if 'package_description' exists...
";
    
    // Check if the new column already exists
    $checkNewQuery = "SHOW COLUMNS FROM records LIKE 'package_description'";
    $newResult = mysqli_query($db, $checkNewQuery);
    
    if (mysqli_num_rows($newResult) > 0) {
        echo "Column 'package_description' already exists. No migration needed.
";
    } else {
        echo "Neither 'product_name' nor 'package_description' column found. Please check your database schema.
";
    }
}

echo "Migration completed.
";
?>