<?php
// models/Expense.php
class Expense {
    private $conn;
    private $table_name = "expenses";

    public $id;
    public $description;
    public $amount;
    public $record_id;
    public $user_id;
    public $branch_id;
    public $entry_date;

    public function __construct($db) {
        $this->conn = $db;
    }

    // Get all expenses with related data
    public function getAll() {
        $query = "SELECT e.*, r.package_description as record_package, u.username as user_name, b.name as branch_name 
                  FROM " . $this->table_name . " e
                  LEFT JOIN records r ON e.record_id = r.id
                  LEFT JOIN users u ON e.user_id = u.id
                  LEFT JOIN branches b ON e.branch_id = b.id
                  ORDER BY e.entry_date DESC";
        
        $result = mysqli_query($this->conn, $query);
        return $result;
    }

    // Get expenses by user ID
    public function getByUserId($user_id, $date = null) {
        $user_id = mysqli_real_escape_string($this->conn, $user_id);
        $query = "SELECT e.*, r.package_description as record_package, u.username as user_name, b.name as branch_name 
                  FROM " . $this->table_name . " e
                  LEFT JOIN records r ON e.record_id = r.id
                  LEFT JOIN users u ON e.user_id = u.id
                  LEFT JOIN branches b ON e.branch_id = b.id
                  WHERE e.user_id = '$user_id'";
        
        if($date) {
            $date = mysqli_real_escape_string($this->conn, $date);
            $query .= " AND DATE(e.entry_date) = '$date'";
        }
        
        $query .= " ORDER BY e.entry_date DESC";
        
        $result = mysqli_query($this->conn, $query);
        return $result;
    }

    // Get expenses by user ID with date range
    public function getByUserIdWithDateRange($user_id, $start_date = null, $end_date = null) {
        $user_id = mysqli_real_escape_string($this->conn, $user_id);
        $query = "SELECT e.*, r.package_description as record_package, u.username as user_name, b.name as branch_name 
                  FROM " . $this->table_name . " e
                  LEFT JOIN records r ON e.record_id = r.id
                  LEFT JOIN users u ON e.user_id = u.id
                  LEFT JOIN branches b ON e.branch_id = b.id
                  WHERE e.user_id = '$user_id'";
        
        if($start_date) {
            $start_date = mysqli_real_escape_string($this->conn, $start_date);
            $query .= " AND DATE(e.entry_date) >= '$start_date'";
        }
        
        if($end_date) {
            $end_date = mysqli_real_escape_string($this->conn, $end_date);
            $query .= " AND DATE(e.entry_date) <= '$end_date'";
        }
        
        $query .= " ORDER BY e.entry_date DESC";
        
        $result = mysqli_query($this->conn, $query);
        return $result;
    }

    // Get expenses by filters
    public function getByFilters($branch_id = null, $start_date = null, $end_date = null) {
        $query = "SELECT e.*, r.package_description as record_package, u.username as user_name, b.name as branch_name 
                  FROM " . $this->table_name . " e
                  LEFT JOIN records r ON e.record_id = r.id
                  LEFT JOIN users u ON e.user_id = u.id
                  LEFT JOIN branches b ON e.branch_id = b.id
                  WHERE 1=1";
        
        if($branch_id) {
            $branch_id = mysqli_real_escape_string($this->conn, $branch_id);
            $query .= " AND e.branch_id = '$branch_id'";
        }
        
        if($start_date) {
            $start_date = mysqli_real_escape_string($this->conn, $start_date);
            $query .= " AND DATE(e.entry_date) >= '$start_date'";
        }
        
        if($end_date) {
            $end_date = mysqli_real_escape_string($this->conn, $end_date);
            $query .= " AND DATE(e.entry_date) <= '$end_date'";
        }
        
        $query .= " ORDER BY e.entry_date DESC";
        
        $result = mysqli_query($this->conn, $query);
        return $result;
    }

    // Get expense by ID
    public function getById($id) {
        $id = mysqli_real_escape_string($this->conn, $id);
        $query = "SELECT e.*, r.package_description as record_package, u.username as user_name, b.name as branch_name 
                  FROM " . $this->table_name . " e
                  LEFT JOIN records r ON e.record_id = r.id
                  LEFT JOIN users u ON e.user_id = u.id
                  LEFT JOIN branches b ON e.branch_id = b.id
                  WHERE e.id = '$id' LIMIT 1";
        
        $result = mysqli_query($this->conn, $query);
        
        if($result && mysqli_num_rows($result) > 0) {
            $row = mysqli_fetch_assoc($result);
            $this->id = $row['id'];
            $this->description = $row['description'];
            $this->amount = $row['amount'];
            $this->record_id = $row['record_id'];
            $this->user_id = $row['user_id'];
            $this->branch_id = $row['branch_id'];
            $this->entry_date = $row['entry_date'];
            return $row; // Return the full row with related data
        }
        return false;
    }

    // Create expense
    public function create() {
        // Sanitize
        $this->description = mysqli_real_escape_string($this->conn, htmlspecialchars(strip_tags($this->description)));
        $this->amount = mysqli_real_escape_string($this->conn, htmlspecialchars(strip_tags($this->amount)));
        $this->record_id = mysqli_real_escape_string($this->conn, htmlspecialchars(strip_tags($this->record_id)));
        $this->user_id = mysqli_real_escape_string($this->conn, htmlspecialchars(strip_tags($this->user_id)));
        $this->branch_id = mysqli_real_escape_string($this->conn, htmlspecialchars(strip_tags($this->branch_id)));
        
        $query = "INSERT INTO " . $this->table_name . " 
                  SET description='$this->description', amount='$this->amount', record_id=NULL, 
                      user_id='$this->user_id', branch_id='$this->branch_id'";
        
        // Handle nullable record_id
        if(!empty($this->record_id)) {
            $query = "INSERT INTO " . $this->table_name . " 
                      SET description='$this->description', amount='$this->amount', record_id='$this->record_id', 
                          user_id='$this->user_id', branch_id='$this->branch_id'";
        }
        
        $result = mysqli_query($this->conn, $query);
        
        if($result) {
            return mysqli_insert_id($this->conn);
        }
        return false;
    }

    // Delete expense
    public function delete() {
        $this->id = mysqli_real_escape_string($this->conn, $this->id);
        $query = "DELETE FROM " . $this->table_name . " WHERE id = '$this->id'";
        $result = mysqli_query($this->conn, $query);
        
        if($result) {
            return true;
        }
        return false;
    }
    
    // Get total expenses
    public function getTotalExpenses($branch_id = null, $date = null) {
        $query = "SELECT SUM(amount) as total_expenses FROM " . $this->table_name . " WHERE 1=1";
        
        if($branch_id) {
            $branch_id = mysqli_real_escape_string($this->conn, $branch_id);
            $query .= " AND branch_id = '$branch_id'";
        }
        
        if($date) {
            $date = mysqli_real_escape_string($this->conn, $date);
            $query .= " AND DATE(entry_date) = '$date'";
        }
        
        $result = mysqli_query($this->conn, $query);
        if($result && mysqli_num_rows($result) > 0) {
            $row = mysqli_fetch_assoc($result);
            return $row['total_expenses'] ?? 0;
        }
        return 0;
    }
}
?>