<?php
// models/User.php
class User {
    private $conn;
    private $table_name = "users";

    public $id;
    public $username;
    public $password;
    public $branch_id;
    public $role;
    public $created_at;
    public $updated_at;

    public function __construct($db) {
        $this->conn = $db;
    }

    // Get all users
    public function getAll() {
        $query = "SELECT u.*, b.name as branch_name FROM " . $this->table_name . " u 
                  LEFT JOIN branches b ON u.branch_id = b.id 
                  ORDER BY u.username";
        $result = mysqli_query($this->conn, $query);
        return $result;
    }

    // Get user by ID
    public function getById($id) {
        $id = mysqli_real_escape_string($this->conn, $id);
        $query = "SELECT * FROM " . $this->table_name . " WHERE id = '$id' LIMIT 1";
        $result = mysqli_query($this->conn, $query);
        
        if($result && mysqli_num_rows($result) > 0) {
            $row = mysqli_fetch_assoc($result);
            $this->id = $row['id'];
            $this->username = $row['username'];
            $this->password = $row['password'];
            $this->branch_id = $row['branch_id'];
            $this->role = $row['role'];
            $this->created_at = $row['created_at'];
            $this->updated_at = $row['updated_at'];
            return true;
        }
        return false;
    }

    // Get user by username
    public function getByUsername($username) {
        $username = mysqli_real_escape_string($this->conn, $username);
        $query = "SELECT * FROM " . $this->table_name . " WHERE username = '$username' LIMIT 1";
        $result = mysqli_query($this->conn, $query);
        
        if($result && mysqli_num_rows($result) > 0) {
            $row = mysqli_fetch_assoc($result);
            $this->id = $row['id'];
            $this->username = $row['username'];
            $this->password = $row['password'];
            $this->branch_id = $row['branch_id'];
            $this->role = $row['role'];
            $this->created_at = $row['created_at'];
            $this->updated_at = $row['updated_at'];
            return true;
        }
        return false;
    }

    // Create user
    public function create() {
        // Sanitize
        $this->username = mysqli_real_escape_string($this->conn, htmlspecialchars(strip_tags($this->username)));
        $this->password = mysqli_real_escape_string($this->conn, htmlspecialchars(strip_tags($this->password)));
        $this->branch_id = mysqli_real_escape_string($this->conn, htmlspecialchars(strip_tags($this->branch_id)));
        $this->role = mysqli_real_escape_string($this->conn, htmlspecialchars(strip_tags($this->role)));
        
        $query = "INSERT INTO " . $this->table_name . " 
                  SET username='$this->username', password='$this->password', branch_id='$this->branch_id', role='$this->role'";
        
        $result = mysqli_query($this->conn, $query);
        
        if($result) {
            return true;
        }
        return false;
    }

    // Update user
    public function update() {
        // Sanitize
        $this->username = mysqli_real_escape_string($this->conn, htmlspecialchars(strip_tags($this->username)));
        $this->branch_id = mysqli_real_escape_string($this->conn, htmlspecialchars(strip_tags($this->branch_id)));
        $this->role = mysqli_real_escape_string($this->conn, htmlspecialchars(strip_tags($this->role)));
        $this->id = mysqli_real_escape_string($this->conn, htmlspecialchars(strip_tags($this->id)));
        
        $query = "UPDATE " . $this->table_name . " 
                  SET username = '$this->username', branch_id = '$this->branch_id', role = '$this->role'";
        
        // Check if password needs to be updated
        if(!empty($this->password)) {
            $this->password = mysqli_real_escape_string($this->conn, htmlspecialchars(strip_tags($this->password)));
            $query .= ", password = '$this->password'";
        }
        
        $query .= " WHERE id = '$this->id'";
        
        $result = mysqli_query($this->conn, $query);
        
        if($result) {
            return true;
        }
        return false;
    }

    // Delete user
    public function delete() {
        $this->id = mysqli_real_escape_string($this->conn, $this->id);
        $query = "DELETE FROM " . $this->table_name . " WHERE id = '$this->id'";
        $result = mysqli_query($this->conn, $query);
        
        if($result) {
            return true;
        }
        return false;
    }
    
    // Validate login
    public function validateLogin($username, $password) {
        if($this->getByUsername($username)) {
            if(password_verify($password, $this->password)) {
                return true;
            }
        }
        return false;
    }
}
?>