<?php
// run_migration.php
// Simple script to run the migration to rename the price column

echo "Running migration to rename 'price' column to 'item_valuation'...\n";

// Database connection details - update these to match your setup
$host = 'localhost';
$username = 'root';
$password = '';
$database = 'fomax_logistics';

// Create connection
$conn = mysqli_connect($host, $username, $password, $database);

if (!$conn) {
    die("Connection failed: " . mysqli_connect_error());
}

echo "Connected to database successfully.\n";

// Check if the old column exists
$checkQuery = "SHOW COLUMNS FROM records LIKE 'price'";
$result = mysqli_query($conn, $checkQuery);

if (mysqli_num_rows($result) > 0) {
    echo "Found 'price' column. Renaming to 'item_valuation'...\n";
    
    // Rename the column
    $renameQuery = "ALTER TABLE records CHANGE price item_valuation DECIMAL(10, 2) NOT NULL";
    
    if (mysqli_query($conn, $renameQuery)) {
        echo "Column renamed successfully!\n";
    } else {
        echo "Error renaming column: " . mysqli_error($conn) . "\n";
    }
} else {
    echo "Column 'price' does not exist. Checking if 'item_valuation' exists...\n";
    
    // Check if the new column already exists
    $checkNewQuery = "SHOW COLUMNS FROM records LIKE 'item_valuation'";
    $newResult = mysqli_query($conn, $checkNewQuery);
    
    if (mysqli_num_rows($newResult) > 0) {
        echo "Column 'item_valuation' already exists. Migration not needed.\n";
    } else {
        echo "Neither 'price' nor 'item_valuation' column found. Please check your database schema.\n";
    }
}

mysqli_close($conn);
echo "Migration script completed.\n";
?>